/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mekanism.api.providers.IItemProvider;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.ChemicalInfuserRecipe;
import mekanism.api.recipes.CombinerRecipe;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.FluidSlurryToSlurryRecipe;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.api.recipes.ItemStackToFluidRecipe;
import mekanism.api.recipes.ItemStackToGasRecipe;
import mekanism.api.recipes.ItemStackToInfuseTypeRecipe;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.api.recipes.ItemStackToPigmentRecipe;
import mekanism.api.recipes.MetallurgicInfuserRecipe;
import mekanism.api.recipes.NucleosynthesizingRecipe;
import mekanism.api.recipes.PaintingRecipe;
import mekanism.api.recipes.PigmentMixingRecipe;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.client.jei.recipe.BoilerJEIRecipe;
import mekanism.client.jei.recipe.SPSJEIRecipe;
import mekanism.common.Mekanism;
import mekanism.common.registries.MekanismBlocks;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraftforge.common.util.Lazy;

public record MekanismJEIRecipeType<RECIPE>(Lazy<ResourceLocation> lazyUid, Class<? extends RECIPE> recipeClass) {
    private static final Map<ResourceLocation, MekanismJEIRecipeType<?>> knownTypes = new HashMap();
    @Nullable
    private static Set<MekanismJEIRecipeType<?>> allKnownTypes = new HashSet();
    public static final MekanismJEIRecipeType<CraftingRecipe> VANILLA_CRAFTING = new MekanismJEIRecipeType<CraftingRecipe>(new ResourceLocation("crafting"), CraftingRecipe.class);
    public static final MekanismJEIRecipeType<ItemStackToItemStackRecipe> CRUSHING = new MekanismJEIRecipeType<ItemStackToItemStackRecipe>(MekanismBlocks.CRUSHER, ItemStackToItemStackRecipe.class);
    public static final MekanismJEIRecipeType<ItemStackToItemStackRecipe> ENRICHING = new MekanismJEIRecipeType<ItemStackToItemStackRecipe>(MekanismBlocks.ENRICHMENT_CHAMBER, ItemStackToItemStackRecipe.class);
    public static final MekanismJEIRecipeType<ItemStackToItemStackRecipe> SMELTING = new MekanismJEIRecipeType<ItemStackToItemStackRecipe>(MekanismBlocks.ENERGIZED_SMELTER, ItemStackToItemStackRecipe.class);
    public static final MekanismJEIRecipeType<ChemicalInfuserRecipe> CHEMICAL_INFUSING = new MekanismJEIRecipeType<ChemicalInfuserRecipe>(MekanismBlocks.CHEMICAL_INFUSER, ChemicalInfuserRecipe.class);
    public static final MekanismJEIRecipeType<CombinerRecipe> COMBINING = new MekanismJEIRecipeType<CombinerRecipe>(MekanismBlocks.COMBINER, CombinerRecipe.class);
    public static final MekanismJEIRecipeType<ElectrolysisRecipe> SEPARATING = new MekanismJEIRecipeType<ElectrolysisRecipe>(MekanismBlocks.ELECTROLYTIC_SEPARATOR, ElectrolysisRecipe.class);
    public static final MekanismJEIRecipeType<FluidSlurryToSlurryRecipe> WASHING = new MekanismJEIRecipeType<FluidSlurryToSlurryRecipe>(MekanismBlocks.CHEMICAL_WASHER, FluidSlurryToSlurryRecipe.class);
    public static final MekanismJEIRecipeType<FluidToFluidRecipe> EVAPORATING = new MekanismJEIRecipeType<FluidToFluidRecipe>(MekanismBlocks.THERMAL_EVAPORATION_CONTROLLER, FluidToFluidRecipe.class);
    public static final MekanismJEIRecipeType<GasToGasRecipe> ACTIVATING = new MekanismJEIRecipeType<GasToGasRecipe>(MekanismBlocks.SOLAR_NEUTRON_ACTIVATOR, GasToGasRecipe.class);
    public static final MekanismJEIRecipeType<GasToGasRecipe> CENTRIFUGING = new MekanismJEIRecipeType<GasToGasRecipe>(MekanismBlocks.ISOTOPIC_CENTRIFUGE, GasToGasRecipe.class);
    public static final MekanismJEIRecipeType<ChemicalCrystallizerRecipe> CRYSTALLIZING = new MekanismJEIRecipeType<ChemicalCrystallizerRecipe>(MekanismBlocks.CHEMICAL_CRYSTALLIZER, ChemicalCrystallizerRecipe.class);
    public static final MekanismJEIRecipeType<ChemicalDissolutionRecipe> DISSOLUTION = new MekanismJEIRecipeType<ChemicalDissolutionRecipe>(MekanismBlocks.CHEMICAL_DISSOLUTION_CHAMBER, ChemicalDissolutionRecipe.class);
    public static final MekanismJEIRecipeType<ItemStackGasToItemStackRecipe> COMPRESSING = new MekanismJEIRecipeType<ItemStackGasToItemStackRecipe>(MekanismBlocks.OSMIUM_COMPRESSOR, ItemStackGasToItemStackRecipe.class);
    public static final MekanismJEIRecipeType<ItemStackGasToItemStackRecipe> PURIFYING = new MekanismJEIRecipeType<ItemStackGasToItemStackRecipe>(MekanismBlocks.PURIFICATION_CHAMBER, ItemStackGasToItemStackRecipe.class);
    public static final MekanismJEIRecipeType<ItemStackGasToItemStackRecipe> INJECTING = new MekanismJEIRecipeType<ItemStackGasToItemStackRecipe>(MekanismBlocks.CHEMICAL_INJECTION_CHAMBER, ItemStackGasToItemStackRecipe.class);
    public static final MekanismJEIRecipeType<NucleosynthesizingRecipe> NUCLEOSYNTHESIZING = new MekanismJEIRecipeType<NucleosynthesizingRecipe>(MekanismBlocks.ANTIPROTONIC_NUCLEOSYNTHESIZER, NucleosynthesizingRecipe.class);
    public static final MekanismJEIRecipeType<ItemStackToEnergyRecipe> ENERGY_CONVERSION = new MekanismJEIRecipeType<ItemStackToEnergyRecipe>(Mekanism.rl("energy_conversion"), ItemStackToEnergyRecipe.class);
    public static final MekanismJEIRecipeType<ItemStackToGasRecipe> GAS_CONVERSION = new MekanismJEIRecipeType<ItemStackToGasRecipe>(Mekanism.rl("gas_conversion"), ItemStackToGasRecipe.class);
    public static final MekanismJEIRecipeType<ItemStackToGasRecipe> OXIDIZING = new MekanismJEIRecipeType<ItemStackToGasRecipe>(MekanismBlocks.CHEMICAL_OXIDIZER, ItemStackToGasRecipe.class);
    public static final MekanismJEIRecipeType<ItemStackToInfuseTypeRecipe> INFUSION_CONVERSION = new MekanismJEIRecipeType<ItemStackToInfuseTypeRecipe>(Mekanism.rl("infusion_conversion"), ItemStackToInfuseTypeRecipe.class);
    public static final MekanismJEIRecipeType<ItemStackToPigmentRecipe> PIGMENT_EXTRACTING = new MekanismJEIRecipeType<ItemStackToPigmentRecipe>(MekanismBlocks.PIGMENT_EXTRACTOR, ItemStackToPigmentRecipe.class);
    public static final MekanismJEIRecipeType<PigmentMixingRecipe> PIGMENT_MIXING = new MekanismJEIRecipeType<PigmentMixingRecipe>(MekanismBlocks.PIGMENT_MIXER, PigmentMixingRecipe.class);
    public static final MekanismJEIRecipeType<MetallurgicInfuserRecipe> METALLURGIC_INFUSING = new MekanismJEIRecipeType<MetallurgicInfuserRecipe>(MekanismBlocks.METALLURGIC_INFUSER, MetallurgicInfuserRecipe.class);
    public static final MekanismJEIRecipeType<PaintingRecipe> PAINTING = new MekanismJEIRecipeType<PaintingRecipe>(MekanismBlocks.PAINTING_MACHINE, PaintingRecipe.class);
    public static final MekanismJEIRecipeType<PressurizedReactionRecipe> REACTION = new MekanismJEIRecipeType<PressurizedReactionRecipe>(MekanismBlocks.PRESSURIZED_REACTION_CHAMBER, PressurizedReactionRecipe.class);
    public static final MekanismJEIRecipeType<RotaryRecipe> CONDENSENTRATING = new MekanismJEIRecipeType<RotaryRecipe>(Mekanism.rl("condensentrating"), RotaryRecipe.class);
    public static final MekanismJEIRecipeType<RotaryRecipe> DECONDENSENTRATING = new MekanismJEIRecipeType<RotaryRecipe>(Mekanism.rl("decondensentrating"), RotaryRecipe.class);
    public static final MekanismJEIRecipeType<SawmillRecipe> SAWING = new MekanismJEIRecipeType<SawmillRecipe>(MekanismBlocks.PRECISION_SAWMILL, SawmillRecipe.class);
    public static final MekanismJEIRecipeType<BoilerJEIRecipe> BOILER = new MekanismJEIRecipeType<BoilerJEIRecipe>(MekanismBlocks.BOILER_CASING, BoilerJEIRecipe.class);
    public static final MekanismJEIRecipeType<SPSJEIRecipe> SPS = new MekanismJEIRecipeType<SPSJEIRecipe>(MekanismBlocks.SPS_CASING, SPSJEIRecipe.class);
    public static final MekanismJEIRecipeType<ItemStackToFluidRecipe> NUTRITIONAL_LIQUIFICATION = new MekanismJEIRecipeType<ItemStackToFluidRecipe>(MekanismBlocks.NUTRITIONAL_LIQUIFIER, ItemStackToFluidRecipe.class);

    public MekanismJEIRecipeType(IItemProvider item, Class<? extends RECIPE> recipeClass) {
        this((Lazy<ResourceLocation>)Lazy.of(item::getRegistryName), recipeClass);
    }

    public MekanismJEIRecipeType(ResourceLocation uid, Class<? extends RECIPE> recipeClass) {
        this((Lazy<ResourceLocation>)Lazy.of(() -> uid), recipeClass);
    }

    public MekanismJEIRecipeType(Lazy<ResourceLocation> lazyUid, Class<? extends RECIPE> recipeClass) {
        if (allKnownTypes == null) {
            knownTypes.put(this.uid(), this);
        } else {
            allKnownTypes.add(this);
        }
        this.lazyUid = lazyUid;
        this.recipeClass = recipeClass;
    }

    public ResourceLocation uid() {
        return (ResourceLocation)this.lazyUid.get();
    }

    public static MekanismJEIRecipeType<?> findType(ResourceLocation name) {
        if (allKnownTypes != null) {
            for (MekanismJEIRecipeType<?> type : allKnownTypes) {
                knownTypes.put(type.uid(), type);
            }
            allKnownTypes = null;
        }
        return knownTypes.computeIfAbsent(name, uid -> {
            throw new IllegalArgumentException("No matching recipe type found.");
        });
    }
}

